/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_243;
import net.minecraft.class_3518;
import org.jspecify.annotations.Nullable;

public final class JsonUtil {
    public static <L, R> @Nullable Either<@Nullable L, @Nullable R> getEither(JsonObject obj, Predicate<JsonObject> leftPredicate, Predicate<JsonObject> rightPredicate, Function<JsonObject, @Nullable L> leftFactory, Function<JsonObject, @Nullable R> rightFactory) {
        return JsonUtil.getEither(obj, null, leftPredicate, rightPredicate, leftFactory, rightFactory);
    }

    public static <L, R> @Nullable Either<@Nullable L, @Nullable R> getEither(JsonObject obj, @Nullable Predicate<JsonObject> nullPredicate, Predicate<JsonObject> leftPredicate, Predicate<JsonObject> rightPredicate, Function<JsonObject, @Nullable L> leftFactory, Function<JsonObject, @Nullable R> rightFactory) {
        if (nullPredicate != null && nullPredicate.test(obj)) {
            return null;
        }
        if (leftPredicate.test(obj)) {
            return Either.left(leftFactory.apply(obj));
        }
        if (rightPredicate.test(obj)) {
            return Either.right(rightFactory.apply(obj));
        }
        throw new JsonParseException("Invalid Json object, contained value was neither of the two possible formats!");
    }

    public static @Nullable class_243 jsonToVec3(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        if (element.isJsonArray()) {
            return JsonUtil.arrayToVec(JsonUtil.jsonArrayToDoubleArray(element.getAsJsonArray()));
        }
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            if (!(object.has("x") && object.has("y") && object.has("z"))) {
                throw new IllegalStateException("Json object input must have x, y, and z properties to parse into a Vec3: " + String.valueOf(element));
            }
            return new class_243(class_3518.method_34927((JsonObject)object, (String)"x"), class_3518.method_34927((JsonObject)object, (String)"y"), class_3518.method_34927((JsonObject)object, (String)"z"));
        }
        throw new IllegalStateException("Json input must be an array or object to parse into a Vec3: " + String.valueOf(element));
    }

    public static double[] jsonArrayToDoubleArray(@Nullable JsonArray array) throws JsonParseException {
        if (array == null) {
            return new double[3];
        }
        double[] output = new double[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            output[i] = array.get(i).getAsDouble();
        }
        return output;
    }

    public static <T> T @Nullable [] jsonArrayToObjectArray(@Nullable JsonArray array, JsonDeserializationContext context, Class<T> objectClass) {
        if (array == null) {
            return null;
        }
        Object[] objArray = (Object[])Array.newInstance(objectClass, array.size());
        for (int i = 0; i < array.size(); ++i) {
            objArray[i] = context.deserialize(array.get(i), objectClass);
        }
        return objArray;
    }

    public static <T> T @Nullable [] jsonArrayToObjectArray(@Nullable JsonArray array, Function<JsonElement, @Nullable T> mappingFunction) {
        if (array == null) {
            return null;
        }
        Object[] objArray = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            T object = mappingFunction.apply(array.get(i));
            if (object == null) continue;
            objArray[i] = object;
        }
        return objArray;
    }

    public static <T> List<T> jsonArrayToList(@Nullable JsonArray array, Function<JsonElement, T> elementTransformer) {
        if (array == null) {
            return new ObjectArrayList();
        }
        ObjectArrayList list = new ObjectArrayList(array.size());
        for (JsonElement element : array) {
            list.add(elementTransformer.apply(element));
        }
        return list;
    }

    public static <T> @Nullable Map<String, T> jsonObjToMap(@Nullable JsonObject obj, JsonDeserializationContext context, Class<T> objectType) {
        if (obj == null) {
            return null;
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(obj.size());
        for (Map.Entry entry : obj.entrySet()) {
            map.put((String)entry.getKey(), context.deserialize((JsonElement)entry.getValue(), objectType));
        }
        return map;
    }

    public static <T> @Nullable Map<String, T> jsonObjToPrimitiveMap(@Nullable JsonObject obj, JsonDeserializationContext context, Function<JsonElement, T> mappingFunction) {
        if (obj == null) {
            return null;
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(obj.size());
        for (Map.Entry entry : obj.entrySet()) {
            map.put((String)entry.getKey(), mappingFunction.apply((JsonElement)entry.getValue()));
        }
        return map;
    }

    public static @Nullable Long getOptionalLong(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Long.valueOf(class_3518.method_22449((JsonObject)obj, (String)elementName)) : null;
    }

    public static @Nullable Boolean getOptionalBoolean(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Boolean.valueOf(class_3518.method_15270((JsonObject)obj, (String)elementName)) : null;
    }

    public static @Nullable Float getOptionalFloat(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Float.valueOf(class_3518.method_15259((JsonObject)obj, (String)elementName)) : null;
    }

    public static @Nullable Double getOptionalDouble(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Double.valueOf(class_3518.method_34927((JsonObject)obj, (String)elementName)) : null;
    }

    public static @Nullable Integer getOptionalInteger(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Integer.valueOf(class_3518.method_15260((JsonObject)obj, (String)elementName)) : null;
    }

    public static class_243 arrayToVec(double[] array) {
        if (array[0] == 0.0 && array[1] == 0.0 && array[2] == 0.0) {
            return class_243.field_1353;
        }
        return new class_243(array[0], array[1], array[2]);
    }

    private JsonUtil() {
    }
}

